
/*  -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: iegd_interface_265.h
 * $Revision: 1.1.2.3 $
 *----------------------------------------------------------------------------
 * Gart and DRM driver for Intel Embedded Graphics Driver
 * Copyright © 2007, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/* Copyright 2003 - 2005 Intel Corporation. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *	Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *      Neither the name Intel Corporation nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* For some arcane reasons this must be defined for 2.6.5 kernel in 
 * intel.h if not the drm won't compile properly.
 */
#if KERNEL265


/* KERNEL265 defines these functions in the drm directory 
 * that got expanded when you #define DRM(x) intel_##x. This is very ugly and
 * confusing. Luckily 2.6.11 don't have this. Can't do much here but follow
 * the rules for it. 
 */
#define DRM(x) intel_##x

/* Changing the permission bits to 0,0 for testing. auth,root permission */
#define DRIVER_IOCTLS							    \
	[DRM_IOCTL_NR(DRM_IOCTL_INTEL_GETPAGES)] = { intel_getpages_265,  0, 0 }, \
	[DRM_IOCTL_NR(DRM_IOCTL_INTEL_FREEPAGES)] = { intel_freepages_265,  0, 0 },\
	[DRM_IOCTL_NR(DRM_IOCTL_INTEL_INFO_INIT)] = { intel_drm_info_init_265,  0, 0 },\
	[DRM_IOCTL_NR(DRM_IOCTL_INTEL_INFO_GET)] = { intel_drm_info_get_265,  0, 0 }   

/* Driver customization:
 */
#define __HAVE_RELEASE		1
#define DRIVER_PRERELEASE() do {				\
	intel_prerelease_265(dev);		\
} while (0)

#define DRIVER_RELEASE() do {				\
} while (0)

#define DRIVER_PRETAKEDOWN() do {					\
} while (0)

#define DRIVER_POSTSETUP() do {					\
} while (0)

#define DRIVER_POSTCLEANUP() do {					\
} while (0)

#define DRIVER_POSTINIT() do {					\
	intel_postinit_265(dev);				\
} while (0)

/*
 * Explaination: For unknown reasons the DRM infrastructure has a lot
 * of really horrid programming techniques to generate custom init
 * code using header files (containing c code) and macros. Apparently
 * this is to save a few nano seconds during init.
 *
 * This logic here is that if you define this magic macro you will use
 * this code to count the number of devices you are supporting. We
 * need to support 2 devices and we don't know the device IDs at startup
 * and there is usually not 2 PCI devices anyway. So we just return 2
 * and worry about it later.
 *
 * Note: DRM has issues with DIH so for now we'll live with one drm
 *#define DRIVER_COUNT_CARDS() 2
 */

/* KERNEL265 defines these functions in the drm directory 
 * that got expanded when you #define DRM(x) intel_##x. This is very ugly and
 * confusing. Luckily 2.6.11 don't have this 
 */
#define REMAP_PAGE(a,b,c,d,e) remap_page_range( \
		DRM_RPR_ARG(a) b ,						\
		c,d,e)
#define ORDER(a) DRM(order)(a) 
#define ALLOC_PAGES(a,b) DRM(alloc_pages)(a,b) 
#define ALLOC(a,b) DRM(alloc)(a,b) 
#define FREE(a,b,c) DRM(free)(a,b,c) 
#define FREE_PAGES(a,b,c) DRM(free_pages)(a,b,c) 

#define LOCK_DRM(d) down(&d->struct_sem)
#define UNLOCK_DRM(d) up(&d->struct_sem)

#endif
/* endif for KERNEL265 */
